#!/bin/bash

BMCIP=192.168.113.10
#BMCIP=192.168.100.44
#BMCIP=192.168.20.20
BMCUSR="root"
BMCPWD="0penBmc"

# PEGA SBIOS
FWPKG="cec1736-apfw-02012502.fwpkg"
# NV ERoT
# FWPKG="cec1736-ecfw-01.03.0136.0000-n01-rel-prod.fwpkg"
# NV VBIOS
# FWPKG="g530_0206_888__96008D0003-prod.fwpkg"
# NV SBIOS
# FWPKG="SBIOS_P5042_PG530_SKU_895_01.01.00_rel_prod.fwpkg"

CHECK_ProcMod_0=0
BUILD_SKU=236
SKU=

while IFS= read -r line
do
    if [[ $line == *"ProcMod_0"* ]]; then
        CHECK_ProcMod_0=1
        echo "$line"
    fi

    if [[ $line == *"Board Part Number"* && $CHECK_ProcMod_0 == 1 ]]; then
        echo "$line"
        if [[ $line == *"0236"* ]]; then
            SKU=236
        elif [[ $line == *"0206"* ]]; then
            SKU=206
        fi
        echo $SKU
        break
    fi
done < <(ipmitool -C 17 -I lanplus -H $BMCIP -U $BMCUSR -P $BMCPWD fru print)

if [[ $BUILD_SKU == $SKU ]]; then
    echo "$BUILD_SKU sameas $SKU, exec SBIOS update process"
    curl -k -H "Content-Type: application/json" -X POST https://${BMCUSR}:${BMCPWD}@${BMCIP}/redfish/v1/UpdateService -T ${FWPKG}
else
    echo "$BUILD_SKU is not $SKU, skip SBIOS update process"
fi
